  rm(list=ls())
  library(copula)
  library(pracma)
  library(DEoptim)
  library(MASS)
  library(NlcOptim)
  
  A<-Sys.time()
  ####### Definiation of algorithm
  #1- Define the Distribution Function
  #2- Calculate the Mean of T using Integral (1-F(t)) from 0 to INF
  #3- markov chain procedure
  #4- Inter the Values where lam10 and lam20 for in control & lam11 and lam21 for out of control
  #5- Start the Optimizition
  ########################################
  #step1
  F<-function(t,lam1,lam2,theta)
  {if(t<=0){A=0}else{A=2-exp(-t/lam1)-exp(-t/lam2) +(1/theta)*log( 1+((exp(-theta*(1-exp(-t/lam1)))-1)*(exp(-theta*(1-exp(-t/lam2)))-1))/(exp(-theta)-1))}
    return(A)
  }
  
  
  #step2 and 3
  
  ATS<-function(LCL,UCL,r,lam1,lam2,theta)
  {
    Fvar<-function(t)
    {
      -1+exp(-t/lam1)+exp(-t/lam2) -(1/theta)*log( 1+((exp(-theta*(1-exp(-t/lam1)))-1)*(exp(-theta*(1-exp(-t/lam2)))-1))/(exp(-theta)-1))
    }
    
    A<-integrate(Fvar,0,+Inf)
    ET<-A$value
    m<-60
    p<-2*m+1 
    Q<-matrix(NA,nrow=p,ncol=p)
    delta<-(UCL-LCL)/(2*p) 
    hr<-linspace(LCL+delta,UCL-delta,p)
    Hj<-matrix(1,nrow=p,ncol = 1)
    Hj<-Hj*hr
    
    
    for (i in 1:p)
      for( j in 1:p)
      {
        Q1<-(Hj[j]+delta-(1-r)*Hj[i])/r
        Q2<-(Hj[j]-delta-(1-r)*Hj[i])/r
        Q[i,j]<-F(Q1,lam1,lam2,theta)-F(Q2,lam1,lam2,theta)
      }
    q<-matrix(0,nrow=p,ncol=1)
    q[m+1]<-1
    one<-matrix(1,nrow=p,ncol=1)
    I<-diag(p)
    singular <- function(m) class(try(solve(m),silent=T))=="matrix"
    if(singular(I-Q)[1]=="FALSE") {ATS=1e5} else
    { ATS<-t(q)%*%inv(I-Q)%*%one*ET}
    return(ATS)
  }
  
  ###STEP 4
  tau=0.3
  theta<-iTau(frankCopula(dim=2),tau=tau)  # calculate theta based on kendall's tau
  LCL=0.98322
  UCL=3.43274
  r=0.07001
  lam10<-2
  lam20<-3
  delta1=1.1
  delta2=0.9
  lam11<-lam10*delta1
  lam21<-lam20*delta2
  ATS0<-370
  ATS(LCL,UCL,r,lam1=lam10,lam2=lam20,theta)
  ATS(LCL,UCL,r,lam1=lam11,lam2=lam21,theta)
  
  
  
  
  #--optimal---parameters--first-method---
  
  
  objfun=function(nc){
    LCL<-nc[1]
    UCL=nc[2]
    r=nc[3]
    out=ATS(LCL,UCL,r,lam1=lam11,lam2=lam21,theta)
    if(r<=0 | r>1) out=1e5
    if(LCL>UCL) out=1e5
    if (abs(ATS(LCL,UCL,r,lam1=lam10,lam2=lam20,theta)-ATS0)>5) out=1e5
    return(out)
  }
  
  nc=c(LCL,UCL,r,lam1=lam10,lam2=lam20,theta)
  objfun(nc)
  
  
  
  de=DEoptim(objfun, lower=c(0.01,0.1,0.01),upper=c(2,10,0.99),
             control=list(itermax=1000,trace=T))
  
  de$optim$bestmem 
  de$optim$bestval
  B<-Sys.time()
  B-A
  LCL=de$optim$bestmem [1]
  UCL=de$optim$bestmem [2]
  r=de$optim$bestmem [3]
  ATS(LCL,UCL,r,lam1=lam11,lam2=lam21,theta)
